import { Message } from "aegis/features/messages";
import { PagedResponse } from "aegis/functionality/models";
import { Admin, Chatroom, ReportContent, ReportReason, User, UserEmoticon, Vod } from "aegis/models";
import { OffsetPageInfo } from "aegis/models/offset_pageinfo";
import { Squad } from "aegis/models/squad";

export class Report {
  id: string;
  status: string;
  audits: ReportAudit[];
  assignedto?: Admin;
  assignedToQueue: ReportQueue;
  content: ReportContent;
  reason: ReportReason;
  createdAt: string;
  updatedAt: string;
  fromUser: User;
  targetUser?: User;
  description: string;
  origin: string;
  language?: string;
  rawContext?: string;
  // tslint:disable-next-line:variable-name
  __typename?: string;
}

export class ReportFilter {
  status?: string[];
  assignedTo?: string; // ID of the assigned to admin
  assignedToQueue?: ReportQueue;
  fromUserID?: string;
  targetUserID?: string;
  fromUserRole?: string;
  targetUserRole?: string;
  content?: string;
  reason?: string;
  language?: string;
  description?: string;
  startTime?: number;
  endTime?: number;
}

export enum ReportQueue {
  Main = "Main",
  Investigative = "Investigative"
}

export class ReportAudit {
  id: string;
  action?: string;
  actionBy?: Admin;
  diff?: string;
  hold?: ReportHold;
  createdAt: Date;
  autoResolveID?: string;
}

export class ReportHold {
  id: string;
  createdBy: Admin;
  until: Date;
  createdAt: Date;
  updatedAt: Date;
}

export class ChatReport extends Report {
  channelID?: string;
  messageID?: string;
  entries?: PagedResponse<Message>;
}

export class ClipReport extends Report {
  clipURL: string;
  clipOverviewURL: string;
  vodURL: string;
  curator: User;
  slug: string;
}

export class CursePrivateGroupReport extends Report {
  messages: Message[];
}

export class CursePublicGroupReport extends Report {
  messages: Message[];
}

export class CommentConnection {
  comments: Comment[];
  pageInfo: OffsetPageInfo;
}

export class Comment {
  id: string;
  reportID: string;
  message: string;
  createdAt: Date;
  createdBy: Admin;
}

export class CurseWhisperReport extends Report {
  messages: Message[];
  rawText?: string;
}

export class EmoteReport extends Report {
  emote?: UserEmoticon;
}

export class ExtensionReport extends Report {
  extensionID?: string;
  extensionURL?: string;
}

export class LegacyReport extends Report {
  contentID?: string;
  extra?: string;
  details?: string;
}

export class UserReport extends Report {
  similarClipsURL: string;
  chatPopupURL: string;
  vod?: Vod;
  squad?: Squad;
}

export class VodReport extends Report {
  vod?: Vod;
}

export class VodCommentReport extends Report {
  vodURL?: string;
  vodComment?: Message;
}

export class WhisperReport extends Report {
  messages?: Message[];
  rawText?: string;
}

export class LiveUpNotificationReport extends Report {
  message?: string;
}

export class RoomReport extends Report {
  messages?: Message[];
  room?: Chatroom;
}
