import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { MyAssignedReportsComponent, TestSelectors } from "./component";

import { ReportViewType } from "aegis/features/report-view";
import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

describe("My assigned reports component", () => {
  describe("renders", () => {
    it("with reports", () => {
      const wrapper = Enzyme.shallow(
        <MyAssignedReportsComponent
          viewType={ReportViewType.Main}
          reportEntries={[mockReport({ id: "id1" }), mockReport({ id: "id2" })]}
          fetchPage={jest.fn()}
          totalPages={1}
          currentPage={1}
        />
      );

      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.Reports }).length).toBe(1);
    });

    it("with no reports", () => {
      const wrapper = Enzyme.shallow(
        <MyAssignedReportsComponent
          viewType={ReportViewType.Main}
          reportEntries={[]}
          fetchPage={jest.fn()}
          totalPages={0}
          currentPage={1}
        />
      );

      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.Reports }).length).toBe(0);
    });
  });
});
