import * as React from "react";

import { QueueHeader } from "../header";
import { MyQueueLink } from "../my-queue-link";
import { PagedReportsComponent, Props as PagedReportProps } from "../paged-reports";

import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  LoadingSpinner,
  SpinnerSize,
  TextType
} from "twitch-core-ui";

export type Props = PagedReportProps;

export enum TestSelectors {
  Reports = "my-assigned-reports--reports"
}

export class MyAssignedReportsComponent extends React.Component<Props> {
  public render() {
    const { reportEntries, currentPage, fetchPage } = this.props;
    const defaultPage = 1;

    if (reportEntries.length === 0) {
      if (currentPage !== defaultPage) {
        // go back to the first page when waiting for reports
        fetchPage(defaultPage);
      }
      return (
        <Layout
          fullWidth
          padding={{ y: 1 }}
          display={Display.Flex}
          alignItems={AlignItems.Center}
          justifyContent={JustifyContent.Center}
          flexDirection={FlexDirection.Column}
        >
          <Layout display={Display.Inline} padding={1}>
            <CoreText type={TextType.H4} color={Color.Alt2}>
              No reports assigned to you... Waiting for more...
            </CoreText>
          </Layout>
          <Layout padding={{ top: 1, bottom: 2 }}>
            <LoadingSpinner size={SpinnerSize.Large} />
          </Layout>
        </Layout>
      );
    }

    return (
      <>
        <QueueHeader>
          <Layout
            fullWidth
            display={Display.Flex}
            justifyContent={JustifyContent.Between}
            alignItems={AlignItems.Center}
          >
            <CoreText type={TextType.H3}>Showing {reportEntries.length} Assigned Report(s)</CoreText>
            <MyQueueLink />
          </Layout>
        </QueueHeader>
        <PagedReportsComponent {...this.props} data-test-selector={TestSelectors.Reports} />
      </>
    );
  }
}
