import * as React from "react";

import { ReportViewType } from "aegis/features/report-view";
import { ReportsComponent } from "../component";
import { QueueHeader } from "../header";
import { Report } from "../models";
import { MyQueueLink } from "../my-queue-link";

import { AlignItems, Button, CoreText, Display, JustifyContent, Layout, TextType } from "twitch-core-ui";

export interface Props {
  reportEntries: Report[];
  hideReport: (report: Report) => void;
  reload: () => void;
}

export enum TestSelectors {
  RefetchButton = "my-hold--refetch-button"
}

export class MyHeldReportsComponent extends React.Component<Props> {
  public render() {
    const { reportEntries, hideReport, reload } = this.props;

    const refetchButton = (
      <Layout padding={{ y: 1 }} fullWidth display={Display.Flex} justifyContent={JustifyContent.Center}>
        <Button data-track-click="my-hold-refetch" data-test-selector={TestSelectors.RefetchButton} onClick={reload}>
          Reload Holds
        </Button>
      </Layout>
    );

    return (
      <>
        <QueueHeader>
          <Layout
            fullWidth
            display={Display.Flex}
            justifyContent={JustifyContent.Between}
            alignItems={AlignItems.Center}
          >
            <CoreText type={TextType.H3}>Showing Report(s) On Hold ({reportEntries.length})</CoreText>
            <MyQueueLink />
          </Layout>
        </QueueHeader>
        <ReportsComponent viewType={ReportViewType.Main} reportEntries={reportEntries} onRemove={hideReport}>
          {refetchButton}
        </ReportsComponent>
      </>
    );
  }
}
