import * as React from "react";

import {
  AlignItems,
  Color,
  CoreLink,
  CoreText,
  Display,
  FlexWrap,
  Layout,
  SVG,
  SVGAsset,
  TextAlign
} from "twitch-core-ui";

export const MyQueueLink: React.SFC = () => {
  return (
    <CoreLink linkTo={"/workspaces"} hoverUnderlineNone>
      <Layout
        display={Display.Flex}
        flexWrap={FlexWrap.NoWrap}
        alignItems={AlignItems.Center}
        textAlign={TextAlign.Center}
        padding={{ x: 1, y: 1 }}
      >
        <CoreText color={Color.Alt2}>Return to My Queue</CoreText>
        <SVG asset={SVGAsset.GlyphArrRight} />
      </Layout>
    </CoreLink>
  );
};
