import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { MockUser } from "aegis/models/mocks";
import { MyReportsComponent, TestSelectors } from "./component";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

describe("My reports component", () => {
  describe("renders", () => {
    it("with reports", () => {
      const wrapper = Enzyme.shallow(
        <MyReportsComponent
          reports={[mockReport({ id: "id1" }), mockReport({ id: "id2" })]}
          onEmpty={jest.fn()}
          reload={jest.fn()}
          hideReport={jest.fn()}
        />
      );

      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.Reports }).length).toBe(1);
    });

    it("with no reports", () => {
      const wrapper = Enzyme.shallow(
        <MyReportsComponent reports={[]} onEmpty={jest.fn()} reload={jest.fn()} hideReport={jest.fn()} />
      );

      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.Reports }).length).toBe(0);
    });
  });

  describe("calls refetch on click", () => {
    it("with reports", () => {
      const reloadFn = jest.fn();
      const wrapper = Enzyme.shallow(
        <MyReportsComponent
          reports={[mockReport({ id: "id1", targetUser: MockUser({ id: "userid1" }) }), mockReport({ id: "id2" })]}
          onEmpty={jest.fn()}
          reload={reloadFn}
          hideReport={jest.fn()}
        />
      );

      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.RefetchButton }).length).toBe(1);
      wrapper
        .find({ "data-test-selector": TestSelectors.RefetchButton })
        .first()
        .simulate("click");

      expect(reloadFn.mock.calls.length).toBe(1);
    });

    it("without reports", () => {
      const reloadFn = jest.fn();
      const wrapper = Enzyme.shallow(
        <MyReportsComponent reports={[]} onEmpty={jest.fn()} reload={reloadFn} hideReport={jest.fn()} />
      );

      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.RefetchButton }).length).toBe(1);
      wrapper
        .find({ "data-test-selector": TestSelectors.RefetchButton })
        .first()
        .simulate("click");

      expect(reloadFn.mock.calls.length).toBe(1);
    });
  });
});
