import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { HeaderComponent } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("My header component", () => {
  it("renders with reports", () => {
    const wrapper = Enzyme.shallow(<HeaderComponent reports={[mockReport()]} holdCount={456} assignedCount={123} />);

    expect(wrapper).toBeTruthy();
  });

  it("renders without reports", () => {
    const wrapper = Enzyme.shallow(<HeaderComponent reports={[]} holdCount={456} assignedCount={123} />);

    expect(wrapper).toBeTruthy();
  });
});
