import * as React from "react";

import { Report } from "aegis/features/reports";
import { QueueHeader } from "../../header";
import { DISPLAY_LIMIT } from "../component";
import { HeaderBar } from "./components/header-bar";

import {
  AlignItems,
  CoreText,
  Display,
  FlexDirection,
  FlexWrap,
  JustifyContent,
  Layout,
  SVGAsset,
  TextType
} from "twitch-core-ui";

export type Props = {
  reports: Report[];
  holdCount: number;
  assignedCount: number;
};

export const HeaderComponent: React.SFC<Props> = ({ reports, holdCount, assignedCount }) => {
  return (
    <QueueHeader>
      <Layout
        display={Display.Flex}
        justifyContent={JustifyContent.Between}
        flexWrap={FlexWrap.NoWrap}
        alignItems={AlignItems.Center}
        fullWidth
      >
        <CoreText type={TextType.H3}>
          Showing {DISPLAY_LIMIT < reports.length ? DISPLAY_LIMIT : reports.length} Report(s) out of {reports.length}
        </CoreText>
        <Layout display={Display.Flex} flexDirection={FlexDirection.Column} alignItems={AlignItems.End}>
          <HeaderBar
            count={assignedCount}
            icon={SVGAsset.AddUser}
            label="Assigned to me"
            linkTo="/workspaces/my-assigned"
          />
          <HeaderBar count={holdCount} icon={SVGAsset.GlyphLength} label="On hold" linkTo="/workspaces/my-hold" />
        </Layout>
      </Layout>
    </QueueHeader>
  );
};
