import * as React from "react";

import {
  AlignItems,
  Background,
  Color,
  CoreLink,
  CoreText,
  Display,
  FlexWrap,
  Layout,
  StyledLayout,
  SVG,
  SVGAsset,
  TextAlign,
  TextType
} from "twitch-core-ui";

interface Props {
  count: number;
  icon: SVGAsset;
  label: string;
  linkTo: string;
}

export const HeaderBar: React.SFC<Props> = ({ count, icon, label, linkTo }) => {
  return (
    <StyledLayout
      display={Display.Flex}
      flexWrap={FlexWrap.NoWrap}
      alignItems={AlignItems.Center}
      textAlign={TextAlign.Center}
      elevation={1}
      background={Background.Alt}
      padding={{ x: 1, y: 1 }}
      margin={{ y: 0.5 }}
    >
      <SVG asset={icon} />
      <CoreText type={TextType.Strong}>{label}</CoreText>
      <Layout padding={{ left: 1, right: 0.5 }} />
      <CoreText color={Color.Alt2}>{`${count}`} total,</CoreText>
      <Layout padding={{ right: 0.5 }} />
      <CoreLink linkTo={linkTo}>show all</CoreLink>
    </StyledLayout>
  );
};
