import * as React from "react";

import gql from "graphql-tag";

import { Report } from "aegis/features/reports";
import { Query } from "aegis/functionality/apollo-wrapper";
import { PollingInterval } from "aegis/models";
import { HeaderComponent } from "./component";

export const FETCH_MY_REPORT_COUNTS = gql`
  query myReportCounts {
    me {
      id
      admin {
        id
        activeHoldCount
        assignedReportsCount
      }
    }
  }
`;

export type MyActiveHoldCountResponse = {
  me?: {
    admin: {
      activeHoldCount: number;
      assignedReportsCount: number;
    };
  };
};

export type Props = {
  reports: Report[];
};
export class MyActiveHoldCountQuery extends Query<MyActiveHoldCountResponse, {}> {}

export class Header extends React.Component<Props> {
  public render() {
    const { reports } = this.props;
    return (
      <MyActiveHoldCountQuery
        displayName="MyActiveHoldCountHeader"
        query={FETCH_MY_REPORT_COUNTS}
        fetchPolicy="network-only"
        pollInterval={PollingInterval.Normal}
        onError={err => {
          console.error("An error occurred fetching my report counts", err);
        }}
      >
        {({ data }) => {
          // Use a default value if there's an error fetching counts
          let holdCount = 0;
          let assignedCount = 0;
          if (data && data.me && data.me.admin) {
            holdCount = data.me.admin.activeHoldCount;
            assignedCount = data.me.admin.assignedReportsCount;
          }

          return <HeaderComponent reports={reports} holdCount={holdCount} assignedCount={assignedCount} />;
        }}
      </MyActiveHoldCountQuery>
    );
  }
}
