import * as React from "react";

import { Layout, Pagination, PaginationMouseEvent } from "twitch-core-ui";
import { Props as ReportComponentProps, ReportsComponent } from "../component";

export interface InputProps {
  fetchPage: (index: number) => void;
  totalPages: number;
  currentPage: number;
}

export type Props = InputProps & ReportComponentProps;

export class PagedReportsComponent extends React.Component<Props> {
  public render() {
    const { currentPage, totalPages } = this.props;

    return (
      <Layout>
        <ReportsComponent {...this.props} />
        <Pagination
          currentPage={currentPage}
          onClickIndex={this.fetchPage}
          totalPages={totalPages}
          onClickNext={this.fetchNext}
          onClickPrevious={this.fetchPrevious}
          previousPageButtonAriaLabel="previous"
          nextPageButtonAriaLabel="next"
        />
      </Layout>
    );
  }

  private fetchPage = (e: PaginationMouseEvent<HTMLDivElement>) => {
    this.props.fetchPage(e.goToPage);
  };

  private fetchPrevious = () => {
    this.props.fetchPage(this.props.currentPage - 1);
  };

  private fetchNext = () => {
    this.props.fetchPage(this.props.currentPage + 1);
  };
}
