import * as React from "react";

import gql from "graphql-tag";

import { Query } from "aegis/functionality/apollo-wrapper";
import { Select } from "twitch-core-ui";

export interface PublicProps {
  onSelect: (content?: string) => void;
  defaultValue?: string;
}

export const FETCH_REPORT_CONTENT_TYPES = gql`
  query reportContent {
    reportContents {
      code
      displayName
    }
  }
`;

export interface Data {
  reportContents: ReportContent[];
}

export interface ReportContent {
  code: string;
  displayName: string;
}

class ReportContentsQuery extends Query<Data, {}> {}

export const ReportContentSelector: React.SFC<PublicProps> = ({ onSelect, defaultValue }) => {
  return (
    <ReportContentsQuery displayName="ReportContainerSelector" query={FETCH_REPORT_CONTENT_TYPES}>
      {({ loading, error, data }) => {
        if (loading) {
          return <div />;
        }
        if (error || !data) {
          console.error("Couldn't fetch content types");
          return <div />;
        }

        return (
          <Select
            onChange={(e: React.FormEvent<HTMLSelectElement>) => {
              onSelect(e.currentTarget.value);
            }}
            defaultValue={defaultValue}
          >
            <option key="none" value={""} />
            {data.reportContents.map(({ code, displayName }) => (
              <option key={code} value={code}>
                {displayName}
              </option>
            ))}
          </Select>
        );
      }}
    </ReportContentsQuery>
  );
};
