import * as React from "react";

import gql from "graphql-tag";

import { Query } from "aegis/functionality/apollo-wrapper";
import { Select } from "twitch-core-ui";

export interface PublicProps {
  onSelect: (reason?: string) => void;
  defaultValue?: string;
}

export const FETCH_REPORT_REASON_TYPES = gql`
  query reportReason {
    reportReasons {
      code
      displayName
    }
  }
`;

export interface Data {
  reportReasons: ReportReason[];
}

export interface ReportReason {
  code: string;
  displayName: string;
}

class ReportReasonsQuery extends Query<Data, {}> {}

export const ReportReasonSelector: React.SFC<PublicProps> = ({ onSelect, defaultValue }) => {
  return (
    <ReportReasonsQuery displayName="ReportReasonSelector" query={FETCH_REPORT_REASON_TYPES}>
      {({ loading, error, data }) => {
        if (loading) {
          return <div />;
        }
        if (error || !data) {
          console.error("Couldn't fetch report reasons");
          return <div />;
        }

        return (
          <Select
            onChange={(e: React.FormEvent<HTMLSelectElement>) => {
              onSelect(e.currentTarget.value);
            }}
            defaultValue={defaultValue}
          >
            <option key="none" value={""} />
            {data.reportReasons.map(({ code, displayName }) => (
              <option key={code} value={code}>
                {displayName}
              </option>
            ))}
          </Select>
        );
      }}
    </ReportReasonsQuery>
  );
};
