import * as React from "react";

import { Select } from "twitch-core-ui";

export interface PublicProps {
  onSelect: (status?: string) => void;
  defaultValue?: string;
}

export const ReportStatusSelector: React.SFC<PublicProps> = ({ onSelect, defaultValue }) => {
  return (
    <Select
      onChange={(e: React.FormEvent<HTMLSelectElement>) => {
        onSelect(e.currentTarget.value);
      }}
      defaultValue={defaultValue}
    >
      <option key="none" value={""} />
      <option key={"new"} value={"new"}>
        New
      </option>
      <option key={"open"} value={"open"}>
        Open
      </option>
      <option key={"resolved"} value={"resolved"}>
        Resolved
      </option>
    </Select>
  );
};
