import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { ShiftType } from "aegis/models";
import { MockShift } from "aegis/models/mocks";
import { WorkspaceTabsComponent } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Workspace Tab", () => {
  it("renders with no shift", () => {
    const wrapper = Enzyme.shallow(<WorkspaceTabsComponent />);

    expect(wrapper).toBeTruthy();
  });

  it("renders with shift leader", () => {
    const wrapper = Enzyme.shallow(<WorkspaceTabsComponent shifts={[MockShift({ type: ShiftType.Leader })]} />);

    expect(wrapper).toBeTruthy();
  });
});
