import * as React from "react";

import gql from "graphql-tag";

import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { Shift } from "aegis/models";
import { PublicProps, WorkspaceTabsComponent } from "./component";

export const MY_SHIFTS_QUERY = gql`
  query MyShifts {
    me {
      id
      admin {
        id
        activeShifts {
          ...ShiftFields
        }
      }
    }
  }

  ${Fragments.ShiftFields}
`;

export interface MyShiftsResponse {
  me: {
    id: string;
    admin: {
      activeShifts: Shift[];
    };
  };
}

class MyShiftsQuery extends Query<MyShiftsResponse> {}

export class WorkspaceTabs extends React.Component<PublicProps> {
  public render() {
    return (
      <MyShiftsQuery displayName="WorkspaceTabs" query={MY_SHIFTS_QUERY}>
        {({ loading, error, data }) => {
          if (loading || error || !data || !data.me || !data.me.admin) {
            return <WorkspaceTabsComponent {...this.props} />;
          }

          return <WorkspaceTabsComponent {...this.props} shifts={data.me.admin.activeShifts} />;
        }}
      </MyShiftsQuery>
    );
  }
}
