import { Shift } from "aegis/features/shifts";
import { CollapsibleCard } from "aegis/functionality/components/collapsible";
import { PanelTitle } from "aegis/functionality/components/panel-title";
import { Me, Shift as ShiftModel, ShiftType } from "aegis/models";
import * as React from "react";
import { AlignItems, Display, FlexDirection, JustifyContent, StyledLayout } from "twitch-core-ui";

export interface Props {
  activeShifts: ShiftModel[];
  me: Me;
}

export enum TestSelectors {
  Shift = "active-shifts-card--shift"
}

export const ActiveShiftsComponent: React.SFC<Props> = ({ activeShifts, me }) => {
  const shifts: JSX.Element[] = [];
  const isActiveLeader = activeShifts.some(v => v.admin && v.admin.id === me.id && v.type === ShiftType.Leader);
  for (const shift of activeShifts) {
    const isMyShift = shift.admin && shift.admin.id === me.id;
    shifts.push(
      <Shift
        key={shift.id}
        shift={shift}
        enableWeightSelector={isActiveLeader || isMyShift}
        isMyShift={isMyShift}
        data-test-selector={TestSelectors.Shift}
      />
    );
  }

  return (
    <StyledLayout
      display={Display.Flex}
      justifyContent={JustifyContent.Center}
      flexDirection={FlexDirection.Column}
      alignItems={AlignItems.Center}
      border
      elevation={2}
      className="report-side-card"
    >
      <CollapsibleCard title={<PanelTitle title="Active admins" length={activeShifts.length} />}>
        {shifts}
      </CollapsibleCard>
    </StyledLayout>
  );
};
