import * as React from "react";

import gql from "graphql-tag";

import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { Me, PollingInterval, Shift as ShiftModel } from "aegis/models";
import { Color, CoreText, LoadingSpinner } from "twitch-core-ui";
import { ActiveShiftsComponent } from "./component";

export const FETCH_ACTIVE_SHIFTS = gql`
  query activeShifts {
    activeShifts {
      ...ShiftFields
    }

    me {
      id
    }
  }

  ${Fragments.ShiftFields}
`;

export type ActiveShiftsResponse = {
  activeShifts: ShiftModel[];
  me: Me;
};

export class ActiveShiftsQuery extends Query<ActiveShiftsResponse> {}

export const ActiveShiftsCard = () => (
  <ActiveShiftsQuery displayName="ActiveShiftsCard" pollInterval={PollingInterval.Fast} query={FETCH_ACTIVE_SHIFTS}>
    {({ loading, error, data }) => {
      if (loading && (!data || !data.activeShifts)) {
        return <LoadingSpinner />;
      }

      if (error) {
        console.error(error);
        return <CoreText color={Color.Error}>An error occurred while loading active shifts: {error.message}</CoreText>;
      }

      if (typeof data === undefined) {
        return <div />;
      } else {
        data = data as ActiveShiftsResponse;
      }

      return <ActiveShiftsComponent activeShifts={data.activeShifts} me={data.me} />;
    }}
  </ActiveShiftsQuery>
);
