import * as React from "react";

import { action, observable } from "mobx";
import { observer } from "mobx-react";

import { Button, ButtonState, ButtonType, Layout } from "twitch-core-ui";

import { PortalModal } from "aegis/functionality/components/portal-modal";
import { Admin, ShiftType } from "aegis/models";

import { CheckInForm } from "./components/check-in-form";

export interface Props {
  createShift: (adminID: string, type: ShiftType, weight: number) => Promise<void>;
  admin: Admin;
  loading: boolean;
  error: boolean;
}

export enum TestSelectors {
  Button = "check-in-button--button",
  Form = "check-in-button--form"
}

@observer
export class CheckInButtonComponent extends React.Component<Props> {
  @observable formVisible = false;

  get checkInForm(): JSX.Element | null {
    if (!this.formVisible) {
      return null;
    }
    const { admin, createShift } = this.props;

    return (
      <PortalModal onClose={this.hideCheckInForm}>
        <CheckInForm
          onSubmit={(type: ShiftType, weight: number) => {
            this.hideCheckInForm();
            createShift(admin.id, type, weight);
          }}
          onCancel={this.hideCheckInForm}
          data-test-selector={TestSelectors.Form}
        />
      </PortalModal>
    );
  }

  public render() {
    const { loading, error, admin } = this.props;
    if (admin.activeShifts.length > 0) {
      // Hide button when on shift
      return null;
    }
    return (
      <Layout margin={{ bottom: 1 }} fullWidth>
        {this.checkInForm}
        <Button
          data-track-click="shift-checkin-show-form"
          fullWidth
          onClick={this.showCheckInForm}
          disabled={error || loading}
          type={error ? ButtonType.Alert : ButtonType.Default}
          state={loading ? ButtonState.Loading : ButtonState.Default}
          data-test-selector={TestSelectors.Button}
        >
          Check In
        </Button>
      </Layout>
    );
  }

  @action
  private showCheckInForm = () => {
    this.formVisible = true;
  };

  @action
  private hideCheckInForm = () => {
    this.formVisible = false;
  };
}
