import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { ButtonState, ButtonType } from "twitch-core-ui";

import { CheckOutButtonComponent, Props, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setupProps = (override?: Partial<Props>): Props => {
  return {
    error: false,
    loading: false,
    onClick: jest.fn(),
    ...override
  };
};

describe("check out button", () => {
  it("handles loading", () => {
    const props = setupProps({ loading: true });
    const wrapper = Enzyme.shallow(<CheckOutButtonComponent {...props} />);
    const button = wrapper.find({ "data-test-selector": TestSelectors.Button });
    expect(button.prop("state")).toBe(ButtonState.Loading);
    expect(button.prop("disabled")).toBeTruthy();
  });

  it("handles error", () => {
    const props = setupProps({ error: true });
    const wrapper = Enzyme.shallow(<CheckOutButtonComponent {...props} />);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Button }).prop("type")).toBe(ButtonType.Alert);
  });

  it("handles error", () => {
    const props = setupProps();
    const wrapper = Enzyme.shallow(<CheckOutButtonComponent {...props} />);
    const button = wrapper.find({ "data-test-selector": TestSelectors.Button });
    button.simulate("click");
    expect(props.onClick).toHaveBeenCalled();
  });
});
