import * as React from "react";

import { Button, ButtonState, ButtonType, SVGAsset } from "twitch-core-ui";

export interface Props {
  loading?: boolean;
  error?: boolean;
  onClick: () => void;
}

export enum TestSelectors {
  Button = "check-out-button--button"
}

export class CheckOutButtonComponent extends React.Component<Props> {
  public render() {
    const { loading, error, onClick } = this.props;
    return (
      <Button
        data-track-click="shift-checkout-submit"
        onClick={onClick}
        disabled={loading}
        state={loading ? ButtonState.Loading : ButtonState.Default}
        icon={SVGAsset.PermissionsRemove}
        type={error ? ButtonType.Alert : ButtonType.Text}
        data-test-selector={TestSelectors.Button}
      />
    );
  }
}
