import * as React from "react";

import gql from "graphql-tag";
import { Mutation } from "react-apollo";

import { WithConfirmationModal } from "aegis/functionality/components/confirmation-modal";
import { Shift } from "aegis/models";
import { FETCH_ACTIVE_SHIFTS } from "../active-shifts-card";
import { CheckOutButtonComponent } from "./component";

interface Props {
  shift: Shift;
  confirm?: boolean;
}

export const DELETE_SHIFT = gql`
  mutation deleteShift($input: DeleteShiftInput!) {
    deleteShift(input: $input) {
      success
    }
  }
`;

type DeleteShiftInput = {
  input: {
    id: string;
  };
};

type DeleteShiftResponse = {
  deleteShift: {
    success: boolean;
  };
};

class DeleteShiftMutation extends Mutation<DeleteShiftResponse, DeleteShiftInput> {}

export class CheckOutButton extends React.Component<Props> {
  public render() {
    const { shift } = this.props;

    return (
      <DeleteShiftMutation mutation={DELETE_SHIFT} refetchQueries={[{ query: FETCH_ACTIVE_SHIFTS }]}>
        {(mutate, { loading, error }) => {
          const deleteShift = async () => {
            mutate({
              variables: {
                input: {
                  id: shift.id
                }
              }
            });
          };
          return (
            <WithConfirmationModal
              onConfirm={deleteShift}
              title="Confirm"
              body={`Are you sure you want to kick ${shift.admin.ldap}?`}
            >
              {confirm => {
                const callback = this.props.confirm ? confirm : deleteShift;
                return <CheckOutButtonComponent loading={loading} error={!!error} onClick={callback} />;
              }}
            </WithConfirmationModal>
          );
        }}
      </DeleteShiftMutation>
    );
  }
}
