import * as React from "react";

import * as FontAwesome from "react-fontawesome";

import { action, observable } from "mobx";
import { observer } from "mobx-react";

import { Shift as ShiftModel } from "aegis/models";

import { AdminRoutesModal } from "aegis/features/shifts/components/shift-weight/components/delete-routes-modal/container";
import {
  Balloon,
  BalloonDirection,
  BalloonSize,
  CoreLink,
  CoreLinkType,
  InjectLayout,
  InjectStyledLayout,
  Layout,
  Position
} from "twitch-core-ui";

export interface Props {
  shift: ShiftModel;
  enabled: boolean;
}

@observer
export class ShiftWeight extends React.Component<Props> {
  @observable private visible = false;

  public render() {
    const { shift, enabled } = this.props;

    return (
      <Layout position={Position.Relative}>
        <InjectStyledLayout className="shift--type-part shift--type-weight">
          <CoreLink
            type={CoreLinkType.Inherit}
            hoverColorInherit
            disabled={!enabled}
            onClick={(enabled && this.toggleWeightVisible) || undefined}
          >
            {`weight: ${shift.weight}`}
            {enabled && (
              <InjectLayout className="shift--type-weight-caret">
                <FontAwesome name="caret-down" />
              </InjectLayout>
            )}
          </CoreLink>
        </InjectStyledLayout>
        <Balloon show={this.visible} direction={BalloonDirection.LeftCenter} size={BalloonSize.Medium}>
          <Layout padding={{ x: 1, y: 1 }}>
            <AdminRoutesModal
              defaultValue={shift.weight}
              adminId={shift.admin.id}
              shiftID={shift.id}
              closeModal={this.hideWeightSelector}
            />
          </Layout>
        </Balloon>
      </Layout>
    );
  }

  @action
  private toggleWeightVisible = () => {
    this.visible = !this.visible;
  };

  @action
  private hideWeightSelector = () => {
    this.visible = false;
  };
}
