import * as React from "react";

import { WeightSelector } from "aegis/features/shifts/components/shift-weight/components/weight-selector";
import { WithConfirmationModal } from "aegis/functionality/components/confirmation-modal";

export interface Props {
  deleteRoutes: () => void;
  shiftID: string;
  defaultValue: number;
  closeModal: () => void;
}
export class AdminRoutesModalComponent extends React.Component<Props> {
  public render() {
    return (
      <WithConfirmationModal
        title="Release Routed Reports?"
        body="Would you like to release your routed reports to the queue for rebalancing?
(Reports manually assigned to you will not be released.)"
        onConfirm={this.props.deleteRoutes}
        onCancel={this.props.closeModal}
        confirmLabelOverride="Release"
        cancelLabelOverride="Keep Reports"
      >
        {confirm => {
          return (
            <WeightSelector
              withSetButton
              defaultValue={this.props.defaultValue}
              shiftID={this.props.shiftID}
              onChange={confirm}
            />
          );
        }}
      </WithConfirmationModal>
    );
  }
}
