import * as React from "react";

import gql from "graphql-tag";
import { Mutation } from "react-apollo";

import { AdminRoutesModalComponent } from "aegis/features/shifts/components/shift-weight/components/delete-routes-modal/component";
import { apolloErrorHandler } from "aegis/functionality/error-notifications";

export const DELETE_ADMIN_ROUTES = gql`
  mutation DeleteAdminRoutes($input: DeleteAdminRoutesInput!) {
    deleteAdminRoutes(input: $input) {
      success
    }
  }
`;

type DeleteAdminRoutesInput = {
  input: {
    adminID: string;
  };
};

type DeletedAdminRoutesResponse = {
  deleteAdminRoutes: {
    success: boolean;
  };
};

export interface DeleteRoutesProps {
  adminId: string;
  shiftID: string;
  defaultValue: number;
  closeModal: () => void;
}

export class DeleteAdminRoutesMutation extends Mutation<DeletedAdminRoutesResponse, DeleteAdminRoutesInput> {}

export const AdminRoutesModal: React.SFC<DeleteRoutesProps> = ({ adminId, shiftID, defaultValue, closeModal }) => {
  return (
    <DeleteAdminRoutesMutation
      mutation={DELETE_ADMIN_ROUTES}
      onCompleted={closeModal}
      onError={apolloErrorHandler("Failed to delete routes")}
    >
      {mutate => {
        const variables: DeleteAdminRoutesInput = {
          input: {
            adminID: adminId
          }
        };
        const mutation = () => {
          mutate({ variables });
        };

        return (
          <AdminRoutesModalComponent
            closeModal={closeModal}
            deleteRoutes={mutation}
            shiftID={shiftID}
            defaultValue={defaultValue}
          />
        );
      }}
    </DeleteAdminRoutesMutation>
  );
};
