import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockShift } from "aegis/models/mocks";
import { Props, Shift, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const newShiftProps = (enabled: boolean): Props => {
  return {
    enableWeightSelector: enabled,
    shift: MockShift()
  };
};

describe("Shift", () => {
  it("renders with enabled weight selector", () => {
    const props = newShiftProps(true);
    const wrapper = Enzyme.shallow(<Shift {...props} />);

    expect(wrapper.find({ "data-test-selector": TestSelectors.ShiftWeight }).length).toBe(1);
  });
  it("renders with disabled weight selector", () => {
    const props = newShiftProps(false);
    const wrapper = Enzyme.shallow(<Shift {...props} />);

    expect(wrapper.find({ "data-test-selector": TestSelectors.ShiftWeight }).length).toBe(1);
  });
});
