import * as React from "react";

import { BAN_FORM_HEADER_TEST_SELECTOR } from "aegis/features/banform/banform-modal";

import { mockedBanFormQueries } from "aegis/features/banform/mocks";
import { MockUser } from "aegis/models/mocks";
import { wrapWithGQLProvider } from "aegis/tests/graphql";
import { mount } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { Button } from "twitch-core-ui";
import { StrikeButton } from "./";

Enzyme.configure({ adapter: new Adapter() });

describe("Portal Modal", () => {
  const modalRoot = document.createElement("div");
  modalRoot.setAttribute("id", "portal-modal-root");
  const body = document.querySelector("body");
  if (body) {
    body.appendChild(modalRoot);
  }

  const globalDiv = document.createElement("div");
  document.body.appendChild(globalDiv);

  it("Does not render strike form before click", () => {
    const wrapper = mount(wrapWithGQLProvider(<StrikeButton />, mockedBanFormQueries).wrappedComponent);
    expect(wrapper.find({ "data-test-selector": BAN_FORM_HEADER_TEST_SELECTOR }).length).toBe(0);
  });

  it("renders the embedded strike form on click without a provided user", () => {
    const wrapper = mount(wrapWithGQLProvider(<StrikeButton />, mockedBanFormQueries).wrappedComponent);
    wrapper.find(Button).simulate("click");
    wrapper.update();
    expect(
      wrapper
        .find({ "data-test-selector": BAN_FORM_HEADER_TEST_SELECTOR })
        .first()
        .text()
    ).toBe("Strike ");
  });

  it("renders the embedded strike form on click with a provided user", () => {
    const wrapper = mount(
      wrapWithGQLProvider(<StrikeButton user={MockUser()} />, mockedBanFormQueries).wrappedComponent
    );
    wrapper.find(Button).simulate("click");
    wrapper.update();
    expect(
      wrapper
        .find({ "data-test-selector": BAN_FORM_HEADER_TEST_SELECTOR })
        .first()
        .text()
    ).toBe("Strike display");
  });
});
