import * as React from "react";

import { action, observable } from "mobx";

import { BanFormModal, PublicProps as BanFormProps } from "aegis/features/banform";
import { PortalModal } from "aegis/functionality/components/portal-modal";
import { User } from "aegis/models";
import { observer } from "mobx-react";
import { Button, ButtonType, Tooltip } from "twitch-core-ui";
import { openStrikeFormInNewTab } from "./utils";

import "./style.scss";

export interface Props {
  label?: string;
  type?: ButtonType;
  user?: User;
  banFormProps?: BanFormProps;
}

export const STRIKE_BUTTON_TEST_SELECTOR = "strike-button__button";

@observer
export class StrikeButton extends React.Component<Props> {
  @observable strikeFormVisible: boolean = false;

  get strikeForm(): JSX.Element {
    return (
      <PortalModal onClose={this.hideStrikeForm}>
        <BanFormModal
          closeModal={this.hideStrikeForm}
          displayName={this.props.user ? this.props.user.displayName : undefined}
          {...this.props.banFormProps}
        />
      </PortalModal>
    );
  }

  public render() {
    return (
      <Tooltip label="Strike (CMD/CTRL+Click to open in new tab)">
        {this.strikeFormVisible ? this.strikeForm : null}
        <Button
          data-track-click="strike-button-click"
          type={this.props.type ? this.props.type : ButtonType.Default}
          onClick={this.onClick}
          ariaLabel="Strike (CMD/CTRL+Click to open in new tab)"
          data-test-selector={STRIKE_BUTTON_TEST_SELECTOR}
        >
          <i className={this.props.label ? "fa fa-ban strike-button__icon" : "fa fa-ban"} />
          {this.props.label ? this.props.label : ""}
        </Button>
      </Tooltip>
    );
  }

  private onClick = (event: React.MouseEvent) => {
    if (event.metaKey || event.altKey || event.ctrlKey) {
      openStrikeFormInNewTab(this.props.banFormProps);
    } else {
      this.showStrikeForm();
    }
  };

  @action
  private hideStrikeForm = () => {
    this.strikeFormVisible = false;
  };

  @action
  private showStrikeForm = () => {
    this.strikeFormVisible = true;
  };
}
