import { PublicProps as BanFormProps } from "aegis/features/banform";
import { errorNotification } from "aegis/functionality/error-notifications";

export const openStrikeFormInNewTab = (banFormProps?: BanFormProps) => {
  const targetUserID = banFormProps && banFormProps.targetUserID;
  const defaultContent = banFormProps && banFormProps.defaultContent;
  const defaultReason = banFormProps && banFormProps.defaultReason;
  const defaultDetailedReason = banFormProps && banFormProps.defaultDetailedReason;
  const placeholders = banFormProps && banFormProps.placeholders;
  const chatlog = placeholders && placeholders.chatlog;
  const whisper = placeholders && placeholders.whisper;
  const reportID = placeholders && placeholders.reportID;

  const queryParams = new Map<string, string | undefined>([
    ["targetUserID", targetUserID],
    ["content", defaultContent],
    ["reason", defaultReason],
    ["detailedReason", defaultDetailedReason],
    ["reportID", reportID],
    ["chatlog", chatlog],
    ["whisper", whisper]
  ]);

  const urlParams: string[] = [];
  queryParams.forEach((value, key) => {
    if (value) {
      const encodedValue = encodeURIComponent(value);
      if (encodedValue.length > 4500) {
        errorNotification(`${key} is too long.`, {
          error: value,
          copyErrorToClipboard: true
        });
      } else {
        urlParams.push(encodeURIComponent(key) + "=" + encodedValue);
      }
    }
  });

  const banformUrl = `/ban?${urlParams.join("&")}`;
  window.open(banformUrl);
};
