import * as React from "react";

import * as classnames from "classnames";
import { inject, observer } from "mobx-react";

import { SettingsStoreProps } from "aegis/stores/settingsstore";

type Props = SettingsStoreProps;

@inject("settingsStore")
@observer
export class Themer extends React.Component<Props, {}> {
  render() {
    const { settingsStore, children } = this.props;
    const themeClasses = classnames({
      container: true,
      "container--fluid": true,
      "tw-root--theme-light": settingsStore!.light,
      "tw-root--theme-dark": settingsStore!.dark,
      "tw-root--hover": true
    });

    return <div className={themeClasses}>{children}</div>;
  }
}
