import * as React from "react";

import { shallow } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { Balloon, CoreText } from "twitch-core-ui";
import { PublicProps, TopNavDropdown } from "./index";

Enzyme.configure({ adapter: new Adapter() });

// tslint:disable-next-line:no-any
const setup = (
  overrides: Partial<PublicProps>,
  // tslint:disable-next-line:no-any
  firstChild: React.ReactElement<any>,
  // tslint:disable-next-line:no-any
  secondChild?: React.ReactElement<any>
) => {
  const combinedProps = overrides;
  const wrapper = shallow(<TopNavDropdown topnavElement={firstChild} dropdownElement={secondChild!} />);
  return {
    props: combinedProps,
    wrapper
  };
};

describe("Topnav Dropdown Menu", () => {
  it("throws an error if you pass the wrong number of children.", () => {
    const child = <div />;
    try {
      setup({}, child);
    } catch (err) {
      expect(err).toBeTruthy();
    }
  });

  it("renders both children when passed right number of children", () => {
    const firstChild = <div>one</div>;
    const secondChild = (
      <Balloon>
        <CoreText>two</CoreText>
      </Balloon>
    );

    const { wrapper } = setup({}, firstChild, secondChild);
    expect(wrapper.find(CoreText)).toHaveLength(1);
  });
});
