import * as React from "react";

import { ClickOutDetector } from "aegis/functionality/components/click-out-detector";
import * as classNames from "classnames";
import { Display, InjectLayout, Interactable, Position, StyledLayout, ZIndex } from "twitch-core-ui";

import "./styles.scss";

export interface PublicProps {
  closeOnClick?: boolean;
  fullWidth?: boolean;
  display?: Display;
  topnavElement: JSX.Element;
  dropdownElement: JSX.Element;
}

interface State {
  isDropdownOpen: boolean;
}

export class TopNavDropdown extends React.Component<PublicProps, State> {
  public state = {
    isDropdownOpen: false
  };

  public render() {
    const dropdownClassname = classNames("top-nav-menu-dropdown", {
      "top-nav-menu-dropdown--toggled": this.state.isDropdownOpen
    });

    const navButton = (
      <Interactable data-track-click="top-nav-tools-dropdown-show" onClick={this.onToggleDropdown}>
        {this.props.topnavElement}
      </Interactable>
    );

    const dropdown = (
      <StyledLayout
        position={Position.Absolute}
        className={dropdownClassname}
        zIndex={ZIndex.Below}
        fullWidth={this.props.fullWidth}
      >
        {this.props.dropdownElement}
      </StyledLayout>
    );

    if (this.props.closeOnClick) {
      return (
        <div>
          <InjectLayout display={this.props.display} fullHeight>
            <ClickOutDetector onClickOut={this.onClickOut}>{navButton}</ClickOutDetector>
          </InjectLayout>
          {dropdown}
        </div>
      );
    } else {
      return (
        <InjectLayout display={this.props.display} fullHeight>
          <ClickOutDetector onClickOut={this.onClickOut}>
            {navButton}
            {dropdown}
          </ClickOutDetector>
        </InjectLayout>
      );
    }
  }

  private onToggleDropdown = () => {
    this.setState({ isDropdownOpen: !this.state.isDropdownOpen });
  };

  private onClickOut = () => {
    this.setState({ isDropdownOpen: false });
  };
}
