import { AuthStore } from "aegis/stores";
import { Reporter, SpadeEvent } from "tachyon-spade-reporter";
import { TrackingClient } from "./component";

export class MockReporter<EventType extends SpadeEvent = SpadeEvent> implements Reporter<EventType> {
  private events: EventType[] = [];

  public reportEvent(event: EventType): void {
    this.events.push(event);
  }

  public getReportedEvents(): EventType[] {
    return this.events;
  }
}

export class MockTrackingClient extends TrackingClient {
  constructor() {
    super(new MockReporter(), new AuthStore());
  }

  public Track() {
    // Do nothing
  }
}
