export enum EventName {
  CreateAutoresolveRule = "aegis_client_autoresolve_rule_create",
  Click = "aegis_client_click",
  Heartbeat = "aegis_client_heartbeat",
  HotkeyUsage = "aegis_client_hotkey_usage",
  Pageview = "aegis_client_pageview",
  CreateReportComment = "aegis_client_report_comment",
  ReportEnterViewport = "aegis_client_report_enter_viewport",
  Screenshot = "aegis_client_screenshot"
}

// Event data types to spade.
// Field names need to match the column names

export interface BaseEvent {
  window_location?: string;
  host?: string;
  admin_id?: string;
}

// ContextualEvent is the metric type that requires additional context (closest ancestor to where the event occurred)
export interface ContextualEvent extends BaseEvent {
  ui_context: string;
}

export interface MemoryEventData {
  js_total_heap_size_bytes?: number;
  js_used_heap_size_bytes?: number;
  js_heap_size_limit_bytes?: number;
}

export interface Heartbeat extends BaseEvent, MemoryEventData {
  tab_in_focus: boolean;
  page_visibility: boolean;
  mouse_clicks: number;
  reports_in_view?: number;
  focused_report_id?: string;
  expanded_report_ids?: string;
}

export interface PageView extends BaseEvent {
  previous_location?: string;
  event_time: number; // unix timestamp in millis
}

export interface Click extends ContextualEvent {
  action: string;
  report_id: string | null;
}

export interface ReportEnterViewport extends BaseEvent {
  report_id: string;
}

export interface HotkeyUsage extends BaseEvent {
  report_id: string;
  hotkey: string;
}

export interface CreateReportComment extends ContextualEvent {
  report_id: string;
  comment_id: string;
}

export interface CreateReportAutoresolve extends BaseEvent {
  report_id: string;
  autoresolve_rule_id: string;
}

export interface Screenshot extends ContextualEvent {
  report_id?: string;
  screenshot_count: number;
}
