import * as React from "react";

import { inject } from "mobx-react";

import { PageViewStoreProps } from "aegis/stores";
import { TrackingClientProps } from "./client";
import { EventName, PageView } from "./models";

@inject("trackingClient")
@inject("pageViewStore")
export class PageViewTracker extends React.Component<TrackingClientProps & PageViewStoreProps> {
  public componentDidMount() {
    const { pageViewStore, trackingClient } = this.props;

    const event: PageView = {
      previous_location: pageViewStore!.previousLocation,
      event_time: new Date().getTime()
    };
    trackingClient!.Track(EventName.Pageview, event);

    pageViewStore!.setPreviousLocation(document.location.pathname);
  }

  public render() {
    return this.props.children;
  }
}
