import * as React from "react";

import { inject } from "mobx-react";
import { InView } from "react-intersection-observer";

import { ReportStoreProps } from "aegis/stores";
import { Report } from "../reports";

export interface Props {
  report: Report;
}

@inject("reportStore")
export class ReportHeartbeatTracker extends React.Component<Props & ReportStoreProps> {
  public render() {
    return (
      <InView as="div" onChange={this.onViewChange}>
        {this.props.children}
      </InView>
    );
  }

  private onViewChange = (inView: boolean | React.FormEvent<HTMLDivElement>) => {
    // onChange is defined in both the inView component and HTML
    // We only want to handle in view changes here
    if (typeof inView !== "boolean") {
      return;
    }

    const { reportStore, report } = this.props;
    if (inView) {
      reportStore!.setReportVisibile(report.id);
    } else {
      reportStore!.setReportNotVisible(report.id);
    }
  };
}
