import * as React from "react";

import { InView } from "react-intersection-observer";

import { AncestorNameContext, AncestorNameContextMapper, withAncestorNameContext } from "aegis/context/ancestor";
import { inject } from "mobx-react";
import { Report } from "../reports";
import { TrackingClientProps } from "./client";
import { EventName, ReportEnterViewport } from "./models";

export interface DataProps {
  report: Report;
}

type Props = DataProps & AncestorNameContext & TrackingClientProps;

@inject("trackingClient")
export class ReportInViewTrackerComponent extends React.Component<Props> {
  public render() {
    return (
      <InView as="div" onChange={this.inViewChange} triggerOnce={true}>
        {this.props.children}
      </InView>
    );
  }

  private inViewChange = (inView: boolean | React.FormEvent<HTMLDivElement>) => {
    // onChange is defined in both the inView component and HTML
    // We only want to handle in view changes here
    if (typeof inView !== "boolean") {
      return;
    }

    // Only track event if the report first shows in view
    if (!inView) {
      return;
    }

    const { trackingClient, report } = this.props;

    const event: ReportEnterViewport = {
      report_id: report.id
    };

    trackingClient!.Track(EventName.ReportEnterViewport, event);
  };
}

export const ReportInViewTracker = withAncestorNameContext<AncestorNameContext, DataProps>(AncestorNameContextMapper)(
  ReportInViewTrackerComponent
);
