import * as React from "react";

import { PageViewTracker } from "./page-view-tracker";

export function withTracking(WrappedComponent: React.ComponentType): React.ComponentType {
  return class extends React.PureComponent {
    public render() {
      return (
        <PageViewTracker>
          <WrappedComponent {...this.props} />
        </PageViewTracker>
      );
    }
  };
}
