import * as React from "react";
import { Button, ButtonSize, ButtonType, CoreLink, CoreLinkType, Tooltip } from "twitch-core-ui";
import "./style.scss";

function popupGoogleTranslate(text: string) {
  const w = window.open(
    `https://translate.google.com/#view=home&op=translate&sl=auto&tl=en&text=${encodeURIComponent(text)}`
  );
  if (w === null) {
    console.error("unable to get window");
    return;
  }
  w.opener = null;
}

export const TranslateButton = (props: { for: string; label?: string; type?: ButtonType; size?: ButtonSize }) => {
  const button = (
    <Button
      data-track-click="translate-button-click"
      type={props.type ? props.type : ButtonType.Default}
      size={props.size ? props.size : undefined}
      onClick={(e: React.MouseEvent<HTMLElement>) => {
        e.preventDefault();
        popupGoogleTranslate(props.for);
      }}
    >
      <i className={props.label ? "fa fa-globe translate__button-icon" : "fa fa-globe"} />
      {props.label ? props.label : ""}
    </Button>
  );
  if (!props.label) {
    return <Tooltip label="Translate">{button}</Tooltip>;
  }
  return button;
};

export enum TranslateIconPlacement {
  None = "none",
  Before = "before",
  After = "after"
}

export const WithTranslatePopup = (props: {
  text: string;
  children: React.ReactNode;
  label?: string;
  iconPlacement?: TranslateIconPlacement;
}) => {
  const iconPlacement = props.iconPlacement || TranslateIconPlacement.None;
  const icon = <i className={`fa fa-globe translate__wrapper-icon-${iconPlacement}`} />;
  return (
    <Tooltip label={`Translate ${props.label}`}>
      <CoreLink
        type={CoreLinkType.Inherit}
        onClick={(e: React.MouseEvent<HTMLElement>) => {
          e.preventDefault();
          popupGoogleTranslate(props.text);
        }}
        hoverColorInherit
      >
        {iconPlacement === TranslateIconPlacement.Before && icon}
        {props.children}
        {iconPlacement === TranslateIconPlacement.After && icon}
      </CoreLink>
    </Tooltip>
  );
};
