import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { Props, TestSelectors, UnresolvedReportsComponent } from "./component";

const setupProps = (override?: Partial<Props>): Props => {
  return {
    total: 100,
    mainQueueRouted: 30,
    investigativeQueue: 50,
    mainQueueAssigned: 20,
    ...override
  };
};

Enzyme.configure({ adapter: new Adapter() });
describe("Unresolved Report Card", () => {
  it("Renders", () => {
    const props = setupProps();
    const wrapper = Enzyme.mount(<UnresolvedReportsComponent {...props} />);

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.title })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.mainQueueRouted })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.mainQueueAssigned })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.investigativeQueue })).toHaveLength(1);

    expect(wrapper.find({ "data-test-selector": TestSelectors.title }).prop("count")).toBe(100);
    expect(wrapper.find({ "data-test-selector": TestSelectors.mainQueueRouted }).prop("count")).toBe(30);
    expect(wrapper.find({ "data-test-selector": TestSelectors.investigativeQueue }).prop("count")).toBe(50);
    expect(wrapper.find({ "data-test-selector": TestSelectors.mainQueueAssigned }).prop("count")).toBe(20);
  });
});
