import * as React from "react";

import { CollapsibleCard } from "aegis/functionality/components/collapsible";
import { AlignItems, Display, FlexDirection, JustifyContent, StyledLayout } from "twitch-core-ui";
import { Row, RowTitle } from "./unresolved-report-row";

export interface Props {
  total: number;
  mainQueueRouted: number;
  investigativeQueue: number;
  mainQueueAssigned: number;
}

export enum TestSelectors {
  title = "unresolved-report-counts-title",
  mainQueueRouted = "unresolved-report-counts-main-queue-routed",
  mainQueueAssigned = "unresolved-report-counts-main-queue-assigned",
  investigativeQueue = "unresolved-report-counts-investigative-queue",
  card = "unresolved-report-counts-card"
}

export const UnresolvedReportsComponent: React.SFC<Props> = ({
  total,
  mainQueueRouted,
  investigativeQueue,
  mainQueueAssigned
}) => {
  return (
    <StyledLayout
      display={Display.Flex}
      justifyContent={JustifyContent.Center}
      flexDirection={FlexDirection.Column}
      alignItems={AlignItems.Center}
      border
      elevation={2}
      className="report-side-card"
      margin={{ top: 1 }}
    >
      <CollapsibleCard
        title={<RowTitle data-test-selector={TestSelectors.title} title="Total unresolved reports" count={total} />}
      >
        <Row
          data-test-selector={TestSelectors.mainQueueRouted}
          text="Main Queue routed"
          toolTip="Unresolved reports that will be distributed between Admins joined to the Main Queue"
          count={mainQueueRouted}
          noBorder
        />
        <Row
          data-test-selector={TestSelectors.mainQueueAssigned}
          text="Main Queue assigned"
          toolTip="Unresolved reports that have been manually assigned to an Admin via the Main Queue"
          count={mainQueueAssigned}
        />
        <Row
          data-test-selector={TestSelectors.investigativeQueue}
          text="Investigative Queue"
          toolTip="Unresolved claimed and unclaimed reports that have been moved to the Investigative Queue"
          count={investigativeQueue}
        />
      </CollapsibleCard>
    </StyledLayout>
  );
};
