import * as React from "react";

import {
  AlignItems,
  CoreText,
  Display,
  FlexWrap,
  JustifyContent,
  Layout,
  StyledLayout,
  Tooltip,
  TooltipDirection
} from "twitch-core-ui";

export interface InfoCardProps {
  text: string;
  count: number;
  noBorder?: boolean;
  toolTip: string;
}

export const Row: React.SFC<InfoCardProps> = ({ text, count, noBorder, toolTip }) => {
  return (
    <Layout fullWidth>
      <StyledLayout
        padding={{ y: 0.5 }}
        display={Display.Flex}
        flexWrap={FlexWrap.NoWrap}
        justifyContent={JustifyContent.Between}
        borderTop={!noBorder}
        margin={{ x: 1 }}
      >
        <Tooltip label={toolTip} direction={TooltipDirection.Left} width={200}>
          <Layout className={"unresolved-report-card-title"}>{text}</Layout>
        </Tooltip>
        <Layout className={"unresolved-report-card-count"}>{count}</Layout>
      </StyledLayout>
    </Layout>
  );
};

export const RowTitle: React.SFC<{ title: string; count: number }> = ({ title, count }) => {
  return (
    <Layout display={Display.Flex} justifyContent={JustifyContent.Between} alignItems={AlignItems.Center} fullWidth>
      <Layout>
        <CoreText>{title}</CoreText>
      </Layout>
      <Layout>
        <CoreText bold>{count}</CoreText>
      </Layout>
    </Layout>
  );
};
