import * as React from "react";

import gql from "graphql-tag";

import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { DetailedUser } from "aegis/models";
import { Color, CoreText } from "twitch-core-ui";
import { LoadingFill } from "../loading-fill";
import { UserCardComponent } from "./component";

export const FETCH_USER_CARD_QUERY = gql`
  query userCard($id: ID, $login: String) {
    user(id: $id, login: $login) {
      ...UserFields
      ...DetailedUserFields
    }
  }
  ${Fragments.UserFields}
  ${Fragments.DetailedUserFields}
`;

type Props = {
  userLogin?: string;
  userID?: string;
};

export type FetchUserCardResponse = {
  user: DetailedUser;
};

export class UserCardQuery extends Query<FetchUserCardResponse> {}

export const UserCard: React.SFC<Props> = ({ userLogin, userID }) => {
  return (
    <UserCardQuery
      displayName="UserCard"
      query={FETCH_USER_CARD_QUERY}
      fetchPolicy="cache-first"
      variables={{
        login: userLogin,
        id: userID
      }}
      skip={!userID && !userLogin}
      errorPolicy="none"
    >
      {({ loading, error, data }) => {
        if (error) {
          console.error("Error occurred fetching report admins", error);
          return <CoreText color={Color.Error}>Error</CoreText>;
        }

        if (!data || !data.user) {
          if (loading) {
            return <LoadingFill />;
          }

          return <div>User Not Found</div>;
        }

        return <UserCardComponent user={data.user} loading={loading} />;
      }}
    </UserCardQuery>
  );
};
