import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { UserCardLink } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("User card link", () => {
  it("renders", () => {
    const userID = "userID";
    const linkableText = <div>linkableText</div>;
    const wrapper = Enzyme.mount(<UserCardLink userID={userID}>{linkableText}</UserCardLink>);

    expect(wrapper).toBeTruthy();
    expect(wrapper.containsMatchingElement(linkableText)).toBeTruthy();
  });
});
