import * as React from "react";

import { UserCard } from "aegis/features/user-card";
import { ToggleBalloonWrapper } from "aegis/functionality/components/toggle-balloon-wrapper";
import { Background, Balloon, BalloonProps } from "twitch-core-ui";

export interface Props {
  userID?: string;
  ballonPropsOverride?: Partial<BalloonProps>;
}

export const UserCardLink: React.SFC<Props> = ({ children, userID, ballonPropsOverride }) => {
  const balloonProps: BalloonProps = {
    show: true,
    tailBackground: Background.Overlay,
    ...ballonPropsOverride
  };
  return (
    <ToggleBalloonWrapper>
      {children}
      <Balloon {...balloonProps}>
        <UserCard userID={userID} />
      </Balloon>
    </ToggleBalloonWrapper>
  );
};
