import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { UserRole } from "aegis/models";
import { UserRoleTags } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("User Role Tags ", () => {
  beforeEach(() => {
    // Suppress "out of mocked data" query error
    spyOn(console, "error");
  });

  describe("renders with no tag", () => {
    const tags: UserRole[] = [];
    it("when expanded", () => {
      expect(Enzyme.shallow(<UserRoleTags roles={tags} expanded />)).toBeTruthy();
    });
    it("when not expanded", () => {
      expect(Enzyme.shallow(<UserRoleTags roles={tags} />)).toBeTruthy();
    });
  });

  describe("renders with multiple tag", () => {
    const tags: UserRole[] = [
      UserRole.Admin,
      UserRole.Affiliate,
      UserRole.Developer,
      UserRole.CEO,
      UserRole.EXEC,
      UserRole.Partner,
      UserRole.Staff,
      UserRole.VerifiedBot
    ];
    it("when expanded", () => {
      expect(Enzyme.shallow(<UserRoleTags roles={tags} expanded />)).toBeTruthy();
    });
    it("when not expanded", () => {
      expect(Enzyme.shallow(<UserRoleTags roles={tags} />)).toBeTruthy();
    });
  });
});
