import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockUser } from "aegis/models/mocks";
import { UserComponent } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("UserInput", () => {
  beforeEach(() => {
    // Suppress "out of mocked data" query error
    spyOn(console, "error");
  });

  it("renders with id without crashing", () => {
    const wrapper = Enzyme.shallow(
      <UserComponent user={MockUser()} showStatus showType>
        sometext
      </UserComponent>
    );

    expect(wrapper).toMatchSnapshot();
  });

  it("renders with login without crashing", () => {
    const wrapper = Enzyme.shallow(
      <UserComponent user={MockUser()} showStatus showType>
        sometext
      </UserComponent>
    );

    expect(wrapper).toMatchSnapshot();
  });

  it("renders with both id and login without crashing", () => {
    const wrapper = Enzyme.shallow(
      <UserComponent user={MockUser()} showStatus showType>
        sometext
      </UserComponent>
    );

    expect(wrapper).toMatchSnapshot();
  });
});
