import * as React from "react";

import { shallow } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockUser } from "aegis/models/mocks";
import { ExpandedUserView, Props } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setup = (overrides?: Partial<Props>) => {
  const combinedProps = {
    user: MockUser(),
    ...overrides
  };
  const wrapper = shallow(<ExpandedUserView {...combinedProps} />);
  return {
    props: combinedProps,
    wrapper
  };
};

describe("Report User", () => {
  it("renders with a valid User", () => {
    const { wrapper } = setup();

    expect(wrapper).toMatchSnapshot();
  });

  it("renders with an invalid User", () => {
    const { wrapper } = setup({ user: undefined });

    expect(wrapper.text()).toBe("User Not Found");
    expect(wrapper).toMatchSnapshot();
  });
});
