import * as React from "react";

import { UserCardLink } from "aegis/features/user-card/user-link";
import { User } from "aegis/models";
import {
  AlignItems,
  BalloonDirection,
  BorderRadius,
  CoreText,
  Display,
  FlexDirection,
  FlexWrap,
  FontSize,
  Interactable,
  InteractableType,
  JustifyContent,
  Layout,
  LineHeight,
  SVG,
  SVGAsset,
  TextType
} from "twitch-core-ui";

export interface Props {
  user: User;
  className?: string;
  balloonDirection?: BalloonDirection;
}

export class ExpandedUserView extends React.Component<Props> {
  public render() {
    const { user } = this.props;

    if (!user) {
      return <div className={this.props.className}>User Not Found</div>;
    }

    const userDisplayAndLogin = (
      <Layout>
        <CoreText fontSize={FontSize.Size5} type={TextType.Strong} lineHeight={LineHeight.Heading}>
          {user.displayName}
        </CoreText>
        <CoreText fontSize={FontSize.Size5} lineHeight={LineHeight.Heading}>
          {user.login}
        </CoreText>
      </Layout>
    );

    const userInfo = (
      <Layout flexGrow={0} flexShrink={1} flexDirection={FlexDirection.Column} padding={{ left: 0.5 }}>
        {userDisplayAndLogin}
      </Layout>
    );

    return (
      <Layout
        display={Display.Flex}
        flexWrap={FlexWrap.NoWrap}
        padding={{ right: 1 }}
        justifyContent={JustifyContent.Between}
        className={this.props.className}
      >
        <Layout flexGrow={0}>
          <UserCardLink userID={user.id} ballonPropsOverride={{ direction: this.props.balloonDirection }}>
            <Interactable
              data-track-click="user-expanded-show-card"
              type={InteractableType.Alpha}
              borderRadius={BorderRadius.Medium}
            >
              <Layout
                display={Display.Flex}
                flexWrap={FlexWrap.NoWrap}
                alignItems={AlignItems.Start}
                padding={{ top: 0.5, right: 0.5, left: 0.5 }}
              >
                <SVG asset={SVGAsset.NavProfile} height={13} width={13} />
                {userInfo}
              </Layout>
            </Interactable>
          </UserCardLink>
        </Layout>
        <Layout padding={{ top: 1 }}>{this.props.children}</Layout>
      </Layout>
    );
  }
}
