import * as React from "react";

import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FlexDirection,
  Icon,
  Layout,
  StyledLayout,
  SVGAsset
} from "twitch-core-ui";

export interface Props {
  IsEscalatePartner: boolean;
}

export const OnEscalateList: React.SFC<Props> = ({ IsEscalatePartner }) => {
  return IsEscalatePartner ? (
    <Layout
      display={Display.Flex}
      flexDirection={FlexDirection.Row}
      alignItems={AlignItems.Center}
      margin={{ right: 0.5 }}
    >
      <StyledLayout color={Color.Link}>
        <Icon asset={SVGAsset.Marker} />
      </StyledLayout>
      <CoreText>Escalated Partner</CoreText>
    </Layout>
  ) : (
    <div />
  );
};
